/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import jgamebase.Const;
import jgamebase.gui.Gui;
import jgamebase.model.DatabaseSelection;

public class DatabaseSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 5990932845446774180L;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private boolean downloadButtonPressed = false;
    private JPanel downloadPanel;
    private JPanel jPanel1;
    private JList list;
    private JButton okButton;
    JScrollPane scrollPane;

    public DatabaseSelectionDialog(Frame parent, final List<? extends DatabaseSelection> items, boolean isDownload) {
        super(parent);
        this.initComponents();
        this.setSize(Gui.scaleByFontSize(this.getSize()));
        this.setIconImage(Const.IMAGE_JGAMEBASE);
        this.setTitle(isDownload ? "Gamebase(s) to download" : "Gamebase to load");
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return items.size();
            }

            @Override
            public Object getElementAt(int i) {
                return items.get(i);
            }
        });
        if (isDownload) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setSelectedIndex(0);
        this.list.setCellRenderer(new Renderer());
        this.downloadPanel.setVisible(isDownload);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.okButton = new JButton();
        this.downloadPanel = new JPanel();
        JButton downloadButton = new JButton();
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DatabaseSelectionDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new BorderLayout());
        this.scrollPane.setPreferredSize(new Dimension(259, 131));
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DatabaseSelectionDialog.this.listMouseClicked(evt);
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DatabaseSelectionDialog.this.listKeyPressed(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        this.jPanel1.add((Component)this.scrollPane, "Center");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.okButton, "South");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        downloadButton.setText("Download Gamebases");
        downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseSelectionDialog.this.downloadButtonActionPerformed(evt);
            }
        });
        this.downloadPanel.add(downloadButton);
        this.getContentPane().add((Component)this.downloadPanel, "South");
        this.setSize(new Dimension(490, 750));
        this.setLocationRelativeTo(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.setVisible(false);
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.downloadButtonPressed = true;
        this.setVisible(false);
    }

    private void listMouseClicked(MouseEvent evt) {
        if (Gui.doubleClick(evt)) {
            this.closeAction = Const.CloseAction.OK;
            this.setVisible(false);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.setVisible(false);
    }

    private void listKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.closeAction = Const.CloseAction.OK;
            this.setVisible(false);
        }
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    public boolean getDownloadButtonPressed() {
        return this.downloadButtonPressed;
    }

    public List<DatabaseSelection> getSelected() {
        return this.list.getSelectedValuesList();
    }

    static class Renderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -402260793264251536L;

        public Renderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DatabaseSelection item = (DatabaseSelection)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(item.getDisplayName());
            if (item.getIcon() != null) {
                this.setIcon(item.getIcon());
            } else {
                this.setIcon(Const.ICON_DEFAULT_DATABASE);
            }
            this.setFont(list.getFont());
            return this;
        }
    }
}

